DROP PROCEDURE [hips].[PcehrMessageQueueDelete]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon Biber
-- Create date: 6 December 2012
-- Description:   Deletes an existing record from the PcehrMessageQueue Table
-- =============================================
CREATE PROCEDURE [hips].[PcehrMessageQueueDelete]
(
	@PcehrMessageQueueId INT
)
AS
BEGIN

SET NOCOUNT ON

DECLARE @intErrorCode INT, @intRowsAffected INT

SELECT  @intErrorCode = 0
		,@intRowsAffected = 0

DELETE [hips].[PcehrMessageQueue]
WHERE [PcehrMessageQueueId] = @PcehrMessageQueueId

SELECT	 @intErrorCode = @@ERROR
		,@intRowsAffected = @@ROWCOUNT

SELECT	@intRowsAffected AS RowsAffected

RETURN(@intErrorCode)

END

GO

